#### **Overview**

- Provides access to Cisco Umbrella Intelligence data.
- Includes live graph analysis of global DNS requests and other contextual data.
- Helps pinpoint attackers' infrastructure and predict future threats.

---

#### **Key Features**

##### **Global Threat Visibility**

- Analysts can view everything Cisco Umbrella knows globally about an Indicator of Compromise (IOC) they have seen locally.
- Enables deeper context for incident investigations.

##### **Search Capabilities**

- Search for:
    - Domain names
    - IP addresses
    - Autonomous System Numbers (ASNs)
    - File hashes
    - Email addresses
- Smart Search: Direct search for specific indicators.
- Pattern Search: Use regular expressions (RegEx) for flexible domain searches.

##### **Advanced Technology**

- Built with:
    - Machine learning
    - Graph theory
    - Anomaly detection
    - Temporal pattern analysis
- Leverages global data from Cisco Umbrella's network.
- Applies big data storage, vector analysis, and other mathematical models to predict and categorize attacks.

---

#### **Benefits**

##### **Proactive Threat Detection**

- **"See attacks as they form"**: Analyze global internet data to identify domains and IPs where attackers stage infrastructure.

##### **Faster Incident Response**

- Up-to-the-minute threat data for domains, IPs, and file hashes.
- Provides historical context to accelerate investigations.

##### **Enhanced Prioritization**

- Uses Cisco Talos Intelligence Group's real-time insights to enrich event data.
- Helps prioritize incidents based on malicious domain context.

##### **RESTful API Integration**

- Integrates seamlessly with:
    - Security Information and Event Management (SIEM) systems
    - Threat intelligence platforms
    - Incident management workflows
- Automatically imports critical data to highlight high-impact incidents.

---

#### **Investigate Console**

- Dashboard with graphical views of:
    - Security scores
    - Threat indicators
- Facilitates visualization and scoring for better decision-making.